<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $campiAggiuntiviRicerca = array("tipoRicerca"=>"ordini","status"=>103);
    if(isset($_GET["cerca"]) && $_GET["tipoRicerca"]=="ordini") {
        $cercaOrdini = $_GET["cerca"];
        $parametriRicerca = array("destinatario"=>filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES));
    }
    else {
        $cercaOrdini = "";
        $parametriRicerca = array();
    }
    
    $parametri = array("tabella"=>"geecEc_ordini", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
      
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
    <h4 class="mb-4 title">Ordini</h4>
    
    <a href="creaOrdine.php" class="btn btn-sm btn-primary" >
	Crea ordine<i class="fas fa-plus ml-2"></i>
    </a>
    <hr> 

    <div class="d-flex justify-content-between mb-3">
        <?php
            $ricerca->stampaSelectNumeroElementi($cercaOrdini,$campiAggiuntiviRicerca);
            $ricerca->stampaFormRicerca($cercaOrdini,$campiAggiuntiviRicerca);
        ?>
    </div>
    <div class="table-responsive table-sm">
    
        <?php

            if(isset($_GET["pag"])) {
                $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
            }
            else {
                $ris = $ricerca->eseguiRicerca(1,"OR");
            }
            
            $colonne = array("ID","Ordinante","Metodo di pagamento","Stato","Importo €","Data ordine","");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
            $tabella->setTipo("normale");
            while($ordine = $ris->fetch_assoc()) {
                
                $destinatarioEscape = filter_var($ordine["destinatario"],FILTER_SANITIZE_ADD_SLASHES);
                $dataOrdine         = date("d/m/Y",strtotime($ordine["dataOrdine"]));
                $fraseAnnullamento  = ($ordine["stato"] == "in attesa di pagamento") ? "Annulla" : "Storna";
                $statoAnnullamento  = ($ordine["stato"] == "in attesa di pagamento") ? "annullato" : "stornato";
                $azioni = array("personalizzato" => "<a class=\"btn visualizza\" href=\"#\" onclick=\"location.href='dettagliOrdine.php?id={$ordine["id"]}';\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Dettagli\"><i class=\"fas fa-info-circle\"></i> </a>
                                                     <a class=\"btn visualizza\" href=\"#\" onclick=\"apriPopupModificaStatoOrdine({$ordine["id"]},'pagato')\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Pagamento accettato\"><i class=\"fas fa-euro-sign\"></i> </a>
                                                     <a class=\"btn visualizza\" href=\"#\" onclick=\"apriPopupModificaStatoOrdine({$ordine["id"]},'spedito')\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Imposta come spedito\"><i class=\"fas fa-truck\"></i> </a>
                                                     <a class=\"btn visualizza\" href=\"stampaOrdine.php?id={$ordine["id"]}&redirect=index\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Stampa\"><i class=\"fas fa-print\"></i> </a>
                                                     <a class=\"btn elimina\" href=\"#\" onclick=\"apriPopupModificaStatoOrdine({$ordine["id"]},'$statoAnnullamento')\"  data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"$fraseAnnullamento\"><i class=\"fas fa-times\"></i> </a>");
                
                if($ordine["idCliente"]==0) {
                    $linkCliente = "";
                }
                else {
                    $datiGeecomAdmin   = $geecomDb->leggiSingolaRiga("geec_prodotti",2);
                    $impostazioniAdmin = $geecomDb->leggiSingolaRiga("geecAd_impostazioni",1);
                    $linkAdmin         = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioniAdmin, $datiGeecomAdmin);
                    $linkCliente       = "<a href=\"$linkAdmin/creaUtente.php?id={$ordine["idCliente"]}\"><i class=\"fas fa-external-link-alt ml-2\"></i></a>";
                }
                
                $tabella->aggiungiNuovaRiga(array("<a href=dettagliOrdine.php?id={$ordine["id"]} ><b>{$ordine["id"]}</b></a>",$destinatarioEscape." ".$linkCliente,$ordine["tipoPagamento"],$ordine["stato"],$ordine["importoTotaleOrdine"],$dataOrdine),$azioni);
            }
            $tabella->stampa("rigaProdotto",0);
            $ricerca->stampaPaginazione(true,"index.php?status=103");
        ?>
    </div>